///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _WINSERVICE_H
#define _WINSERVICE_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _X64_
	#define DisplayName      "NetworkDLS SQL-Exchange Client x64"
	#define ServiceName      "NetworkDLS_SQLExg_Client x64"
	#define ServiceEventName "NetworkDLS_SQLExg_Client_Event x64"

	#define OpenMainDialogEventName    "Open_MainDialog_Client_Event x64"
	#define OpenServerConsoleEventName "Open_Console_Client_Event x64"
#elif _IA64_
	#define DisplayName      "NetworkDLS SQL-Exchange Client IA64"
	#define ServiceName      "NetworkDLS_SQLExg_Client IA64"
	#define ServiceEventName "NetworkDLS_SQLExg_Client_Event IA64"

	#define OpenMainDialogEventName    "Open_MainDialog_Client_Event IA64"
	#define OpenServerConsoleEventName "Open_Console_Client_Event IA64"
#else
	#define DisplayName      "NetworkDLS SQL-Exchange Client x86"
	#define ServiceName      "NetworkDLS_SQLExg_Client x86"
	#define ServiceEventName "NetworkDLS_SQLExg_Client_Event x86"

	#define OpenMainDialogEventName    "Open_MainDialog_Client_Event x86"
	#define OpenServerConsoleEventName "Open_Console_Client_Event x86"
#endif

#define _Yes_	  1
#define _No_	  2
#define _Error_   3
#define _Success_ 4

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI ServiceThread(LPVOID lpVoid);

int CommandService(DWORD dwCommand);
int InstallService(char *sModuleName);
int IsServiceActive(void);
int IsServiceInstalled(void);
int ServiceEntry(void);
int StartService(void);
int TriggerEvent(char *sEventName);
int UninstallService(void);
int SetServiceDescription(char *sDescr);

void WINAPI ControlHandler(DWORD dwMessage);
void WINAPI ServiceMain(DWORD dwNumServiceArgs, LPTSTR *lpServiceArgs);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern DWORD dwServiceThread_ID;

extern HANDLE hOpenConsole_Handle;
extern HANDLE hOpenMainDialog_Handle;
extern HANDLE hServiceEventHandle;
extern HANDLE hServiceThread_Handle;

extern SERVICE_STATUS stServiceStatus;
extern SERVICE_STATUS_HANDLE sthServiceStatusHandler;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
